<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Deliver extends Model 
{

    protected $table = 'delivers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('sale_id', 'costumer_id', 'address_id', 'deliver_at');
    protected $visible = array('sale_id', 'costumer_id', 'address_id', 'deliver_at');

    public function address()
    {
        return $this->hasOne('App\Entities\Adresses');
    }

}